<?php
namespace App\Controllers;

use App\Models\DB;
use function App\Helpers\csrf_field;
use function App\Helpers\csrf_verify;
use function App\Helpers\audit;
use function App\Helpers\redirect;
use function App\Helpers\url;
use function App\Helpers\handleupload;

class TownMeetingsAndReportsController {

    public static function index(): string {
        $pdo = DB::pdo();
        $sql = "SELECT * FROM townmeetingsandreports ORDER BY Year desc";
        $rows = $pdo->query($sql)->fetchAll();
        ob_start();
        $title = 'TownMeetingsAndReports';
        include __DIR__ . '/../Views/townmeetingsandreports/list.php';
        return ob_get_clean();
    }

    public static function create(): string {
        $resource = [];
        ob_start();
        $title = 'New TownMeetingsAndReports';
        include __DIR__ . '/../Views/townmeetingsandreports/form.php';
        return ob_get_clean();
    }

    public static function store(): void {
        csrf_verify();
        $pdo = DB::pdo();
        $createdBy = \App\Helpers\current_username();
        $data = [
            'Year'          => trim((string)($_POST['Year'         ] ?? '')),   
            'MeetingDate'   => trim((string)($_POST['MeetingDate'  ] ?? '')),
            'WarrantUrl'    => trim((string)($_POST['WarrantUrl'   ] ?? '')),
            'MeetingUrl'    => trim((string)($_POST['MeetingUrl'   ] ?? '')),
            'IsActive'      => (isset($_POST['IsActive']) ? 1 : 0),
            'CreatedAt'     => trim((string)($_POST['CreatedAt'    ] ?? '')),
            'CreatedBy' => $createdBy
        ];

        $sql = "INSERT INTO townmeetingsandreports (Year, MeetingDate, WarrantUrl, MeetingUrl, IsActive, CreatedAt, CreatedBy) VALUES (?, ?, ?, ?, ?, NOW(0), ?)";
        $stmt = $pdo->prepare($sql);
        $stmt->execute([
          $data['Year'         ],
          $data['MeetingDate'  ],
          $data['WarrantUrl'   ],
          $data['MeetingUrl'   ],
          $data['IsActive'     ],
          $data['CreatedBy'    ]
        ]);

        $id = (int)$pdo->lastInsertId();
        audit('TownMeetingsAndReports','create',$id,$data);
        redirect('/townmeetingsandreports');
    }

    public static function edit(): string {
        $id = (int)($_GET['id'] ?? 0);
        $pdo = DB::pdo();
        $stmt = $pdo->prepare("SELECT * FROM townmeetingsandreports WHERE Id=?");
        $stmt->execute([$id]);
        $resource = $stmt->fetch();
        if (!$resource) {
            http_response_code(404);
            return "Not found";
        }
        ob_start();
        $title = 'Edit';
        include __DIR__ . '/../Views/townmeetingsandreports/form.php';
        return ob_get_clean();
    }

    public static function update(): void {
        csrf_verify();
        $id = (int)($_POST['Id'] ?? 0);
        $pdo = DB::pdo();
        $sel = $pdo->prepare("SELECT * FROM townmeetingsandreports WHERE Id=?");
        $sel->execute([$id]);
        $before = $sel->fetch() ?: [];

        $data = [
            'Year'          => trim((string)($_POST['Year'         ] ?? '')),   
            'MeetingDate'   => trim((string)($_POST['MeetingDate'  ] ?? '')),
            'WarrantUrl'    => trim((string)($_POST['WarrantUrl'   ] ?? '')),
            'MeetingUrl'    => trim((string)($_POST['MeetingUrl'   ] ?? '')),
            'IsActive'      => (isset($_POST['IsActive']) ? 1 : 0)
        ];
        $sql = "UPDATE townmeetingsandreports SET Year=?, MeetingDate=?, WarrantUrl=?, MeetingUrl=?, IsActive=? WHERE Id=?";
        $stmt = $pdo->prepare($sql);
        $stmt->execute([
          $data['Year'         ],
          $data['MeetingDate'  ],
          $data['WarrantUrl'   ],
          $data['MeetingUrl'   ],
          $data['IsActive'     ],
          $id
        ]);

        $sel->execute([$id]);
        $after = $sel->fetch() ?: [];
        audit('TownMeetingsAndReports','update',$id,['before'=>$before,'after'=>$after]);
        redirect('/townmeetingsandreports');
    }

    public static function delete(): void {
        csrf_verify();
        $id = (int)($_POST['id'] ?? 0);
        $pdo = DB::pdo();
        $sel = $pdo->prepare("SELECT * FROM townmeetingsandreports WHERE Id=?");
        $sel->execute([$id]);
        $row = $sel->fetch() ?: [];
        $stmt = $pdo->prepare("DELETE FROM townmeetingsandreports WHERE Id=?");
        $stmt->execute([$id]);
        audit('TownMeetingsAndReports','delete',$id,['before'=>$row]);
        redirect('/townmeetingsandreports');
    }
}
