<?php
$title = $title ?? 'Add Attachment';
include __DIR__ . '/../layout.php';
$resource = $resource ?? [];
$ParentTableVal = $resource['ParentTable'] ?? ($_GET['parent'] ?? '');
$ParentIdVal    = $resource['ParentId'] ?? (int)($_GET['id'] ?? 0);
$ParentTitleVal = $resource['ParentTitle'] ?? ($_GET['ptitle'] ?? '');
?>
<h2 class="mb-3"><?= htmlspecialchars($title) ?></h2>
<form action="<?= App\Helpers\url('/attachments/store') ?>" method="post"
      class="needs-validation" novalidate enctype="multipart/form-data">
  <?= App\Helpers\csrf_field() ?>
  <input type="hidden" name="ParentTable" value="<?= htmlspecialchars($ParentTableVal) ?>">
  <input type="hidden" name="ParentId" value="<?= (int)$ParentIdVal ?>">
  <input type="hidden" name="ParentTitle" value="<?= htmlspecialchars($ParentTitleVal) ?>">

  <div class="actions">
    <button type="submit">Save</button>
    <a href="<?= App\Helpers\url('/attachments?parent=' . urlencode($ParentTableVal) . '&id=' . urlencode((string)$ParentIdVal) . '&ptitle=' . urlencode($ParentTitleVal)) ?>">Cancel</a>
  </div>

  <div class="form-row"><br>
    <label for="Title">Title *</label>
    <input class="form-control" id="Title" type="text" name="Title" required>
    <div class="invalid-feedback">Title is required.</div>
  </div>

  <fieldset style="border:1px solid #ccc;padding:10px;margin:10px 0">
    <legend>URL (if using a link)</legend>
    <div class="form-row">
      <label for="Url">Url</label>
      <input class="form-control" id="Url" type="url" name="Url" placeholder="">
    </div>
  </fieldset>

  <fieldset style="border:1px solid #ccc;padding:10px;margin:10px 0">
    <legend>File (if referencing or uploading a file)</legend>

    <!-- ✅ NEW: File upload input -->
    <div class="form-row">
      <label for="attachment">Select File (uploads to /TownOfCushingME/uploads/)</label>
      <input class="form-control" id="attachment" type="file" name="attachment">
    </div>

    <div class="form-row">
      <label for="FilePath">FilePath (relative preferred)</label>
      <input class="form-control" id="FilePath" type="text" name="FilePath" placeholder="">
    </div>
    <div class="form-row">
      <label for="FileName">FileName</label>
      <input class="form-control" id="FileName" type="text" name="FileName" placeholder="">
    </div>
  </fieldset>

  <div class="form-row">
    <input type="checkbox" id="IsActive" name="IsActive" value="1" checked>
    <label for="IsActive">Active</label>
  </div>
</form>

<?php include __DIR__ . '/../layout_footer.php'; ?>

<script>
(() => {
  const forms = document.querySelectorAll('.needs-validation');
  Array.from(forms).forEach(form => {
    form.addEventListener('submit', event => {
      if (!form.checkValidity()) {
        event.preventDefault();
        event.stopPropagation();
      }
      form.classList.add('was-validated');
    }, false);
  });
})();
</script>
