<?php
$title = $title ?? 'Attachments';
include __DIR__ . '/../layout.php';
?>
<h2 class="mb-3"><?= htmlspecialchars($title) ?></h2>

<!--p><a class="btn btn-primary" href="<?= App\Helpers\url('/attachments/create?parent=' . urlencode($_GET['parent'] ?? '') . '&id=' . urlencode($_GET['id'] ?? '')) ?>">Add Attachment</a></p-->
<p>
  <a class="btn btn-primary"
     href="<?= App\Helpers\url(
         '/attachments/create?parent=' . urlencode($_GET['parent'] ?? '') .
         '&id=' . urlencode($_GET['id'] ?? '') .
         '&ptitle=' . urlencode($_GET['ptitle'] ?? '')
     ) ?>">
     Add Attachment
  </a>
</p>

<table class="table table-striped">
  <thead>
    <tr>
      <th>ID</th>
      <th>Title</th>
      <th>Source</th>
      <th>Active</th>
      <th>Actions</th>
    </tr>
  </thead>
  <tbody>
    <?php foreach ($rows as $r): ?>
      <tr>
        <td><?= (int)$r['AttachmentId'] ?></td>
        <td><?= htmlspecialchars($r['Title']) ?></td>
        <td>
          <?php if (!empty($r['Url'])): ?>
            <a target="_blank" href="<?= htmlspecialchars($r['Url']) ?>"><?= htmlspecialchars($r['Url']) ?></a>
            <?php else: ?>
              <?php if (!empty($r['FilePath']) && !empty($r['FileName'])): ?>

    <?php
      // Dynamically determine your web root (e.g. /TownOfCushingME)
      $basePath = rtrim(dirname($_SERVER['SCRIPT_NAME'], 2), '/');
    ?>
    <a target="_blank" href="<?= htmlspecialchars($basePath . '/' . ltrim($r['FilePath'], '/')) ?>">
      <?= htmlspecialchars($r['FileName']) ?>
    </a>

                <!--a target="_blank" href="<?= App\Helpers\url('/' . ltrim($r['FilePath'], '/')) ?>"><?= htmlspecialchars($r['FileName']) ?></a-->
<!--a target="_blank" href="/TownOfCushingME/<?= htmlspecialchars(ltrim($r['FilePath'], '/')) ?>">
    <?= htmlspecialchars($r['FileName']) ?>
</a-->

              <?php else: ?>
                <?= htmlspecialchars(($r['FilePath'] ?? '') . '/' . ($r['FileName'] ?? '')) ?>
              <?php endif; ?>
            <?php endif; ?>
        </td>
        <td><?= !empty($r['IsActive']) ? 'Yes' : 'No' ?></td>
        <td>
          <form action="<?= App\Helpers\url('/attachments/delete') ?>" method="post" style="display:inline" onsubmit="return confirm('Delete this attachment?')">
            <?= App\Helpers\csrf_field() ?>
            <input type="hidden" name="Id" value="<?= (int)$r['AttachmentId'] ?>">
            <button type="submit">Delete</button>
          </form>
        </td>
      </tr>
    <?php endforeach; ?>
  </tbody>
</table>

<p><a href="javascript:history.back()">Back</a></p>

<?php include __DIR__ . '/../layout_footer.php'; ?>
