<?php
// ---- add this guard at the very top ----
if (!isset($model) && isset($resource) && is_array($resource)) { $model = $resource; }
if (!isset($model) || !is_array($model)) { $model = []; }
$isEdit = !empty($model['Id']);
// ----------------------------------------

// $boards : array of [Id, Name]
// $page_title : title string

$isEdit = !empty($model['Id']);
$action = $isEdit ? '/boardmeetingminutes/update' : '/boardmeetingminutes/store';
$baseUrl        = App\Helpers\url('/boardmeetingminutes');
$ptitle   = ($_SESSION['board_context']['ptitle'] ?? '');

$entitySingular = 'Meeting Minutes';
$parentTable = 'boardmeetingminutes';
//$pageTitle      = !empty($model['Id']) ? 'Edit Meeting Minutes (BoardName = $model['BoardName'] : 'New Meeting Minutes (BoardName = $model['BoardName']';
$pageTitle = sprintf(
    '%s Meeting Minutes (Board = %s)',
    !empty($model['Id']) ? 'Edit' : 'New',
    $ptitle ?? ''
);

$formAction     = App\Helpers\url(!empty($model['Id']) ? '/boardmeetingminutes/update' : '/boardmeetingminutes/store');

$fields = [
    [
        'type'     => 'date',
        'name'     => 'Date',
        'label'    => 'Date',
        'required' => true,
    ],
    [
        'type'  => 'url',
        'name'  => 'AgendaUrl',
        'label' => 'Agenda (PDF URL)',
        'url'   => true,
        'value' => $model['AgendaUrl'] ?? '',
    ],
    [
        'type'  => 'url',
        'name'  => 'ApprovedMinutesUrl',
        'label' => 'Approved Minutes (PDF URL)',
        'url'   => true,
        'value' => $model['ApprovedMinutesUrl'] ?? '',
    ],
    [
        'type'  => 'url',
        'name'  => 'RecordingUrl',
        'label' => 'Recording (URL)',
        'url'   => true,
        'value' => $model['RecordingUrl'] ?? '',
    ],
];

$cfg = [
    'title'       => $page_title,
    'action'      => $action,
    'method'      => 'POST',
    'submit_text' => $isEdit ? 'Update' : 'Create',
    'cancel_url'  => '/boardmeetingminutes',
    'fields'      => $fields,
];

$showSpecial = false;
$showActive = false;

require __DIR__ . '/../shared/form_base.php';
