<?php
/** @var array $model */
/** @var array $errors */
if (!isset($model) && isset($resource) && is_array($resource)) { $model = $resource; }
if (!isset($model) || !is_array($model)) { $model = []; }
if (!isset($errors) || !is_array($errors)) { $errors = []; }

$isEdit = !empty($model['Id']);
$pageTitle  = $isEdit ? 'Edit Fire and Safety' : 'New Fire and Safety';
$baseUrl    = App\Helpers\url('/fireandsafety');
$formAction = App\Helpers\url($isEdit ? '/fireandsafety/update' : '/fireandsafety/store');

/** Fields for shared/form_base.php */
$fields = [
  ['label'=>'Category'     , 'name'=>'Category'     , 'type'=>'text'],
  ['label'=>'Position'     , 'name'=>'Position'     , 'type'=>'text'],
  ['label'=>'Name'         , 'name'=>'Name'         , 'type'=>'text'],
  ['label'=>'Email'        , 'name'=>'Email'        , 'type'=>'email'],
  ['label'=>'Url'          , 'name'=>'Url'          , 'type'=>'text', 'url'=>true, 'pattern'=>'https?://.+'],
  ['label'=>'Phone'        , 'name'=>'Phone'        , 'type'=>'text', 'phone'=>true],
  ['label'=>'Home/Cell/Work', 'name'=>'PhoneLocation', 'type'=>'text'],
  ['label'=>'Notes'        , 'name'=>'Notes'        , 'type'=>'text']

];

$showActive = true;
$showSpecial = false;

require __DIR__ . '/../shared/form_base.php';
