<?php /* layout.php */ ?>
<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title><?= htmlspecialchars($title ?? 'Town Of Cushing Maine') ?></title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <!--link rel="stylesheet" href="/assets/css/theme.css"-->
  <!--link rel="stylesheet" href="/assets/css/style.css"-->
  <style>
    :root{ --ink:#1c1c1c; --muted:#666; --line:#e8e8e8; --accent:#2f6df6; --ok:#0a7a2a; }
    .site-header h1 a{ text-decoration:none; color:inherit; }
    nav a{ margin-right:12px; text-decoration:underline; }
    .actions{ white-space:nowrap; }
    .badge-yes{color:#fff;background:var(--ok);border-radius:999px;padding:2px 8px;font-size:12px}
    .badge-no{color:#333;background:#eee;border-radius:999px;padding:2px 8px;font-size:12px}
    .form-row{margin-bottom:12px}
    /* Site background colors */
    --site-bg-light-blue: aliceblue;
    /* alternatives:
       lightcyan
       powderblue
       #eef6ff (still named semantically)
    */
    body {
        background-color: var(--site-bg-light-blue);
    }
  </style>
<style>
  /* Make long text and URLs wrap nicely in list tables */
  table.table td {
    white-space: normal;
    word-break: break-word;
    max-width: 400px; /* adjust as needed */
  }
</style>
</head>
<body>
<header class="site-header py-3 mb-2 border-bottom">
  <div class="container">
    <h1 class="mb-1"><a href="<?= App\Helpers\url('/') ?>">Town Of Cushing Maine</a></h1>
    <nav class="mb-1">
      <a href="<?= App\Helpers\url('/') ?>">Home</a>
      <a href="<?= App\Helpers\url('/announcements') ?>">Announcements</a>
      <!--a href="<?= App\Helpers\url('/boardlinks') ?>">BoardLinks</a-->
      <a href="<?= App\Helpers\url('/boardsandcommittees') ?>">Boards/Committees</a>
      <a href="<?= App\Helpers\url('/boardsandcommitteemembers') ?>">Board or Committee Members</a>
      <a href="<?= App\Helpers\url('/boardmeetings') ?>">Board Meetings</a>
      <!--a href="<?= App\Helpers\url('/boardschedulerules') ?>">BoardScheduleRules</a-->
      <a href="<?= App\Helpers\url('/community') ?>">Community</a>
      <a href="<?= App\Helpers\url('/events') ?>">Events</a>
      <a href="<?= App\Helpers\url('/fireandsafety') ?>">Fire/Safety</a>
      <a href="<?= App\Helpers\url('/information') ?>">Information</a>
      <!--a href="<?= App\Helpers\url('/officerpositions') ?>">OfficerPositions</a-->
      <a href="<?= App\Helpers\url('/ordinancesregulationsforms') ?>">Ordinances/Regulations/Forms</a>
      <a href="<?= App\Helpers\url('/resources') ?>">Resources</a>
      <a href="<?= App\Helpers\url('/taxmaps') ?>">TaxMaps</a>
      <a href="<?= App\Helpers\url('/town') ?>">Town Info</a>
      <a href="<?= App\Helpers\url('/townmeetingsandreports') ?>">Town Meetings/Reports</a>
      <a href="<?= App\Helpers\url('/townstaffpositions') ?>">Town Staff</a>
      <!--a href="<?= App\Helpers\url('/login') ?>">Login</a-->
    </nav>
  </div>
</header>
<main class="container my-3">
