<?php /* shared/form_base.php */ ?>
<?php include __DIR__ . '/../layout.php'; ?>

<?php
// ---- Default checkbox visibility ----
// Screens may define $showAdmin, $showActive, $showSpecial.
// If they don't, we supply defaults here, the default being don't show, so any
// screen that wants these to show must add them as $showAdmin = true; etc etc
$showAdmin  = $showAdmin  ?? false;
$showActive = $showActive ?? false;
$showSpecial = $showSpecial ?? false;
?>

<h2><?= htmlspecialchars($pageTitle ?? (($isEdit ?? false) ? ("Edit " . ($entitySingular ?? 'Item')) : ("New " . ($entitySingular ?? 'Item')))) ?></h2>

<?php if (!empty($headerButtons) && is_array($headerButtons)): ?>
  <div class="mb-3 d-flex gap-2 flex-wrap">
    <?php foreach ($headerButtons as $btn) { echo $btn; } ?>
  </div>
<?php endif; ?>

<form class="needs-validation" novalidate method="post"
      action="<?= htmlspecialchars($formAction) ?>"
      enctype="multipart/form-data">
  <div class="mt-3 d-flex gap-2">
    <button type="submit" class="btn btn-primary">Save</button>
    <a href="<?= htmlspecialchars($baseUrl) ?>" class="btn btn-outline-primary">Cancel</a>
  </div><br>

  <?= App\Helpers\csrf_field() ?>
  <?php if (!empty($model['Id'])): ?>
    <input type="hidden" name="Id" value="<?= (int)$model['Id'] ?>">
  <?php endif; ?>
  <?php if (!empty($model['BoardId'])): ?>
    <input type="hidden" name="BoardId" value="<?= (int)$model['BoardId'] ?>">
  <?php endif; ?>

  <?php foreach ($fields as $f): ?>
    <div class="form-row">
      <?php
        // If not a url field, write the label, otherwise we take care of the entire url field later
        if (empty($f['url'])): 
      ?>
        <label class="form-label"><?= htmlspecialchars($f['label']) ?><?= !empty($f['required']) ? ' *' : '' ?></label>
      <?php endif; ?>

      <?php
      $type = $f['type'] ?? 'text';
      $name = $f['name'];
      $value = htmlspecialchars($r[$name] ?? '', ENT_QUOTES, 'UTF-8');
      ?>
      <?php
        // If a url field, do nothing yet, we take care of the entire url field later
        if (!empty($f['url'])): 
      ?>

      <?php elseif ($type === 'datalist'): ?>

     <input
        list="<?= htmlspecialchars($f['list']) ?>"
        name="<?= htmlspecialchars($f['name']) ?>"
        value="<?= htmlspecialchars($model[$f['name']] ?? '') ?>"
        class="form-control"
      >
      <datalist id="<?= htmlspecialchars($f['list']) ?>">
        <?php foreach ($dropdownOptions as $opt): ?>
          <option value="<?= htmlspecialchars($opt) ?>"></option>
        <?php endforeach; ?>
      </datalist>

      <?php elseif (($f['type'] ?? 'text') === 'year'): ?>
          <input
              type="number"
              name="<?= htmlspecialchars((string)($f['name'] ?? '')) ?>"
              class="form-control"
              value="<?= htmlspecialchars((string)($model[$f['name']] ?? ($f['default'] ?? ''))) ?>"
              min="<?= (int)($f['min'] ?? 1800) ?>"
              max="<?= (int)($f['max'] ?? date('Y') + 1) ?>"
              <?= !empty($f['required']) ? 'required' : '' ?>
              <?= !empty($f['pattern']) ? 'pattern="'.htmlspecialchars((string)$f['pattern']).'"' : '' ?>
          >

      <?php elseif (($f['type'] ?? 'text') === 'textarea'): ?>
        <textarea name="<?= htmlspecialchars((string)($f['name'] ?? '')) ?>" rows="<?= (int)($f['rows'] ?? 5) ?>"
                  class="form-control" <?= !empty($f['required']) ? 'required' : '' ?>
                  <?= !empty($f['pattern']) ? 'pattern="'.htmlspecialchars((string)$f['pattern']).'"' : '' ?>><?= htmlspecialchars((string)($model[$f['name']] ?? ($f['default'] ?? ''))) ?></textarea>
      <?php elseif (($f['type'] ?? 'text') === 'select'): ?>
        <?php
          // Normalize
          $nameSafe = isset($f['name']) && is_scalar($f['name']) ? (string)$f['name'] : '';
          $current  = $nameSafe !== '' ? (string)($model[$nameSafe] ?? '') : '';

          // Build options from either 'options' (flat list) or 'choices' (assoc map)
          $opts = [];
          if (isset($f['options']) && is_array($f['options'])) {
              // flat list: values are labels
              foreach ($f['options'] as $opt) {
                  if (is_scalar($opt)) {
                      $opts[(string)$opt] = (string)$opt;
                  }
              }
          } elseif (isset($f['choices']) && is_array($f['choices'])) {
              // choices may be assoc or flat; coerce to value => label
              $isAssoc = array_keys($f['choices']) !== range(0, count($f['choices']) - 1);
              if ($isAssoc) {
                  foreach ($f['choices'] as $val => $lab) {
                      if (is_scalar($val) && (is_scalar($lab) || is_null($lab))) {
                          $opts[(string)$val] = (string)($lab ?? $val);
                      }
                  }
              } else {
                  foreach ($f['choices'] as $val) {
                      if (is_scalar($val)) {
                          $opts[(string)$val] = (string)$val;
                      }
                  }
              }
          }
        ?>
        <select name="<?= htmlspecialchars($nameSafe) ?>" class="form-select" <?= !empty($f['required']) ? 'required' : '' ?>>
          <?php foreach ($opts as $val => $lab): ?>
            <option value="<?= htmlspecialchars((string)$val) ?>" <?= ($current === (string)$val ? 'selected' : '') ?>>
              <?= htmlspecialchars((string)$lab) ?>
            </option>
          <?php endforeach; ?>
        </select>

      <?php else: ?>
        <input type="<?= htmlspecialchars((string)($f['type'] ?? 'text')) ?>"
               name="<?= htmlspecialchars((string)($f['name'] ?? '')) ?>"
               value="<?= htmlspecialchars((string)($model[$f['name']] ?? ($f['default'] ?? ''))) ?>"
               class="form-control" <?= !empty($f['required']) ? 'required' : '' ?>
               <?= !empty($f['pattern']) ? 'pattern="'.htmlspecialchars((string)$f['pattern']).'"' : '' ?>
               <?= !empty($f['readonly']) ? 'readonly' : '' ?>
               <?= !empty($f['disabled']) ? 'disabled' : '' ?>
               <?= !empty($f['phone']) ? 'data-phone="1"' : '' ?>>
      <?php endif; ?>

      <?php if (!empty($f['help'])): ?>
        <!--div class="form-text"><?= $f['help'] ?></div-->
      <?php endif; ?>
      <?php if (!empty($f['required'])): ?>
        <!--div class="invalid-feedback"><?= htmlspecialchars($f['label']) ?> is required.</div-->
      <?php endif; ?>

      <?php if (!empty($f['help'])): ?>
        <div class="form-text"><?= $f['help'] ?></div>
      <?php endif; ?>

      <?php
        // Choose validation message based on field type
        $invalidMsg = '';
        if (!empty($f['type'])) {
          if ($f['type'] === 'email') {
            $invalidMsg = 'Invalid email address.';
          } elseif ($f['type'] === 'url') {
            $invalidMsg = 'Invalid URL.';
          }
        }

        // Fallback for required or generic invalid fields
        if (empty($invalidMsg)) {
          if (!empty($f['required'])) {
            $invalidMsg = htmlspecialchars($f['label']) . ' is required.';
          } else {
            $invalidMsg = htmlspecialchars($f['label']) . ' is invalid.';
          }
        }
      ?>

      <div class="invalid-feedback"><?= $invalidMsg ?></div>

    </div>

    <?php if (!empty($f['url'])): ?>
      <!-- ✅ Compact two-line upload + read-only URL display -->
      <div class="form-row align-items-center mb-3">
        <label class="form-label"><?= htmlspecialchars($f['label']) ?><?= !empty($f['required']) ? ' *' : '' ?></label>
        <div class="input-group">
          <label class="btn btn-outline-secondary mb-0" for="attachment_<?= htmlspecialchars($f['name']) ?>">
            Choose File
          </label>
          <!--input type="file" id="attachment_<?= htmlspecialchars($f['name']) ?>"
             name="attachment" class="d-none" accept="*/*"-->

          <input type="file" id="attachment_<?= htmlspecialchars($f['name']) ?>"
             name="attachment_<?= htmlspecialchars($f['name']) ?>" class="d-none" accept="*/*">

          <input type="text" class="form-control"
            id="url_display_<?= htmlspecialchars($f['name']) ?>"
            name="<?= htmlspecialchars($f['name']) ?>"
            value="<?= htmlspecialchars((string)($model[$f['name']] ?? ($f['default'] ?? ''))) ?>"
            placeholder="URL will appear here">
        </div>
      </div>

      <script>
      // Auto-populate the read-only URL field when a file is chosen, this handles screens with more than 1 Url
      document.addEventListener('DOMContentLoaded', function() {
        const prepend = "<?= addslashes($GLOBALS['CONFIG']['app']['PrependURL']) ?>";
        const safeTable = "<?= addslashes($parentTable ?? ($entitySingular ?? 'file')) ?>";
        const year = new Date().getFullYear();

        // Find all file inputs that start with 'attachment_'
        document.querySelectorAll('input[type="file"][id^="attachment_"]').forEach(fileInput => {
          const fieldName = fileInput.id.replace('attachment_', '');
          const urlField = document.getElementById('url_display_' + fieldName);
          if (!urlField) return;

          fileInput.addEventListener('change', function() {
            if (!this.files.length) return;
            const file = this.files[0];
            urlField.value = `${prepend}uploads/${year}/${safeTable}/${file.name}`;
          });
        });
      });
      </script>

  <?php endif; ?>

  <?php endforeach; ?>

  <?php if (($showAdmin ?? true)): ?>
    <div class="form-row form-check mt-1">
      <input class="form-check-input" type="checkbox" id="IsAdmin" name="IsAdmin"
        <?= (!isset($model['IsAdmin']) || $model['IsAdmin']) ? 'checked' : '' ?>>
      <label class="form-check-label ms-1" for="IsAdmin">Admin</label>
    </div>

    <!-- Admin-only password field (hidden unless IsAdmin is checked) -->
    <div id="AdminPasswordRow" class="form-row mt-1" style="display:none;">
      <label class="form-label" for="AdminPassword">Admin Password</label>
      <input
        type="password"
        id="AdminPassword"
        name="AdminPassword"
        class="form-control"
        autocomplete="new-password"
        placeholder="Enter new password (leave blank to keep existing)"
      >
      <div class="form-text">Leave blank to keep the current password.</div>
    </div>

    <script>
      document.addEventListener('DOMContentLoaded', function () {
        const isAdminBox = document.getElementById('IsAdmin');
        const passRow = document.getElementById('AdminPasswordRow');

        function toggleAdminPassword() {
          if (isAdminBox.checked) {
            passRow.style.display = '';
          } else {
            passRow.style.display = 'none';
          }
        }

        toggleAdminPassword();
        isAdminBox.addEventListener('change', toggleAdminPassword);
      });
    </script>
  <?php endif; ?>

  <?php if (($showActive ?? true)): ?>
    <div class="form-row form-check mt-1">
      <input class="form-check-input" type="checkbox" id="IsActive" name="IsActive" <?= (!isset($model['IsActive']) || $model['IsActive']) ? 'checked' : '' ?>>
      <label class="form-check-label ms-1" for="IsActive">Active</label>
    </div>
  <?php endif; ?>

  <?php if (($showSpecial ?? true)): ?>
    <div class="form-row form-check mt-1">
      <input class="form-check-input" type="checkbox" id="IsSpecial" name="IsSpecial" <?= (!isset($model['IsSpecial']) || $model['IsSpecial']) ? 'checked' : '' ?>>
      <label class="form-check-label ms-1" for="IsSpecial">Special</label>
    </div>
  <?php endif; ?>
</form>

<script>
document.addEventListener('DOMContentLoaded', function() {
  const form = document.querySelector('form.needs-validation');
  if (!form) return;

  form.addEventListener('submit', function(event) {
    const start = form.querySelector('[name="StartDate"]');
    const end = form.querySelector('[name="EndDate"]');
    let valid = true;

    // Let built-in HTML validation run first
    if (!form.checkValidity()) {
      valid = false;
    }

    // Only run the date comparison if both have values
    if (start && end && start.value && end.value) {
      if (new Date(start.value) > new Date(end.value)) {
        valid = false;

        // mark both fields invalid
        //start.classList.add('is-invalid');
        end.classList.add('is-invalid');

        // Create or reuse a feedback message
        let msg = end.parentElement.querySelector('.invalid-feedback.date-range');
        if (!msg) {
          msg = document.createElement('div');
          msg.className = 'invalid-feedback date-range';
          msg.textContent = 'End date cannot be before start date.';
          end.parentElement.appendChild(msg);
        }
      } else {
        // clear invalid if previously marked
        start.classList.remove('is-invalid');
        end.classList.remove('is-invalid');
        const msg = end.parentElement.querySelector('.invalid-feedback.date-range');
        if (msg) msg.remove();
      }
    }

    // Stop submit if invalid
    if (!valid) {
      event.preventDefault();
      event.stopPropagation();
    }

    // Add Bootstrap validation styling
    form.classList.add('was-validated');
  });
});
</script>

<script>
document.addEventListener('DOMContentLoaded', function() {
  const form = document.querySelector('form.needs-validation');
  if (!form) return;

  form.addEventListener('submit', function(event) {
    let valid = true;

    // Run built-in Bootstrap/HTML validation first
    if (!form.checkValidity()) valid = false;

    // Get references to your three date fields
    const initial = form.querySelector('[name="InitialApptDate"]');
    const reapp   = form.querySelector('[name="ReappointmentDate"]');
    const expiry  = form.querySelector('[name="ExpiryDate"]');

    // Helper to safely parse yyyy-mm-dd values
    const getDate = el => el && el.value ? new Date(el.value) : null;

    const d1 = getDate(initial);
    const d2 = getDate(reapp);
    const d3 = getDate(expiry);

    // clear old messages
    [initial, reapp, expiry].forEach(f => {
      if (!f) return;
      f.classList.remove('is-invalid');
      const msg = f.parentElement.querySelector('.invalid-feedback.date-seq');
      if (msg) msg.remove();
    });

    // Validation rules:
    // 1. ReappointmentDate cannot be before InitialApptDate
    if (d1 && d2 && d2 < d1) {
      valid = false;
      reapp.classList.add('is-invalid');
      let msg = reapp.parentElement.querySelector('.invalid-feedback.date-seq');
      if (!msg) {
        msg = document.createElement('div');
        msg.className = 'invalid-feedback date-seq';
        msg.textContent = 'Reappointment date cannot be before initial appointment.';
        reapp.parentElement.appendChild(msg);
      }
    }

    // 2. ExpiryDate cannot be before ReappointmentDate (if both exist)
    if (d2 && d3 && d3 < d2) {
      valid = false;
      expiry.classList.add('is-invalid');
      let msg = expiry.parentElement.querySelector('.invalid-feedback.date-seq');
      if (!msg) {
        msg = document.createElement('div');
        msg.className = 'invalid-feedback date-seq';
        msg.textContent = 'Expiry date cannot be before reappointment date.';
        expiry.parentElement.appendChild(msg);
      }
    }

    // 3. ExpiryDate cannot be before InitialApptDate (in case Reappointment is empty)
    if (d1 && d3 && d3 < d1) {
      valid = false;
      expiry.classList.add('is-invalid');
      let msg = expiry.parentElement.querySelector('.invalid-feedback.date-seq');
      if (!msg) {
        msg = document.createElement('div');
        msg.className = 'invalid-feedback date-seq';
        msg.textContent = 'Expiry date cannot be before initial appointment.';
        expiry.parentElement.appendChild(msg);
      }
    }

    // Block submit if invalid
    if (!valid) {
      event.preventDefault();
      event.stopPropagation();
    }

    form.classList.add('was-validated');
  });
});
</script>

<script src="https://cdn.jsdelivr.net/npm/inputmask@5.0.8/dist/inputmask.min.js"></script>
<script>
document.addEventListener('DOMContentLoaded', function() {
  // For phone number mask
  // Pattern: (207) 555-1212
  const mask = new Inputmask({
    mask: "(999) 999-9999",
    showMaskOnHover: false,
    removeMaskOnSubmit: false
  });

  // Apply mask only to fields marked with data-phone="1"
  document.querySelectorAll('input[data-phone="1"]').forEach(el => {
    mask.mask(el);

    // Auto-format pasted numbers like 2075551212 or 207-555-1212
    el.addEventListener('blur', function() {
      let raw = el.value.replace(/\D/g, '');
      if (raw.length === 10) {
        el.value = `(${raw.slice(0,3)}) ${raw.slice(3,6)}-${raw.slice(6)}`;
      }
    });
  });

  // Bootstrap validation hook
  const forms = document.querySelectorAll('.needs-validation');
  Array.prototype.forEach.call(forms, form => {
    form.addEventListener('submit', e => {
      let valid = true;
      form.querySelectorAll('input[data-phone="1"]').forEach(el => {
      const digits = el.value.replace(/\D/g,'');
      // allow blank phone numbers
      if (digits.length === 0) {
        el.classList.remove('is-invalid');
        return;  // skip validation entirely
      }
      if (digits.length !== 10) {
        el.classList.add('is-invalid');
        valid = false;
      } else {
        el.classList.remove('is-invalid');
      }
      });
      if (!form.checkValidity() || !valid) {
        e.preventDefault();
        e.stopPropagation();
      }
      form.classList.add('was-validated');
    });
  });
});
</script>


<?php include __DIR__ . '/../layout_footer.php'; ?>
