<?php
// $rows    : result set from controller
// $page_title : title string

$baseUrl        = App\Helpers\url('/town');
$pageTitle      = 'Town Info';
$entityPlural   = 'Town Info';
$entitySingular = 'Town Info';

$listColumns    = [
    [
        'label'     => 'Name',
        'field'     => 'Name'
    ],
    [
        'label'     => 'Address1',
        'field'     => 'Address1',
    ],
    [
        'label'     => 'Town',
        'field'     => 'Town',
    ],
    [
        'label'     => 'State',
        'field'     => 'State',
    ],
    [
        'label'     => 'Zip',
        'field'     => 'Zip',
    ],
    [
        'label'     => 'Email',
        'field'     => 'Email',
        'email'     => true
    ],
];

$cfg = [
    'title'       => $page_title,
    'edit_url'    => '/town/edit',   // expects ?id={Id}
    'columns'     => [
        ['header' => 'Name',         'field' => 'Name'],
        ['header' => 'Address1',     'field' => 'Address1'],
        ['header' => 'Town',         'field' => 'Town'],
        ['header' => 'State',        'field' => 'State'],
        ['header' => 'Zip',          'field' => 'Zip'],
        ['header' => 'Email',        'field' => 'Email', 'email'=>true],
    ],
];

$showActive = true;
$showSpecial = false;

require __DIR__ . '/../shared/list_base.php';
