<h2 class="h5">Upcoming Meetings & Events</h2>
<?php if (empty($events)): ?>
  <p class="text-muted mb-0">No upcoming events listed.</p>
<?php else: ?>
  <div class="row g-3">
    <?php foreach ($events as $e): $id = (int)$e['Id']; ?>
      <div class="col-12 col-md-6 col-lg-4">
        <article class="card h-100">
          <div class="card-body">
            <h3 class="h6 mb-2 text-center"><?= hbold($e['Title']) ?></h3>
            <?php if (!empty($e['Body'])): ?>
              <?= body_center('<p>'.esc($e['Body']).'</p>') ?>
            <?php endif; ?>
            <p class="text-center text-muted my-2">
              <?= esc($e['AllDay'] ? 'All day' : date('M j, Y g:i A', strtotime($e['StartDateTime']))) ?>
              <?php if (!empty($e['EndDateTime'])): ?> – <?= esc(date('g:i A', strtotime($e['EndDateTime']))) ?><?php endif; ?>
              <?php if (!empty($e['Location'])): ?> · <?= esc($e['Location']) ?><?php endif; ?>
            </p>
            <?= render_attachments($evtAtt[$id] ?? []) ?>
          </div>
        </article>
      </div>
    <?php endforeach; ?>
  </div>
<?php endif; ?>
