<h2 class="h5">Fire & Safety</h2>

<?php if (empty($fireandsafety)): ?>
  <p class="text-muted mb-0">No Fire & Safety entries found.</p>
<?php else: ?>
  <div class="row g-3">
    <?php foreach ($fireandsafety as $fs): ?>
      <div class="col-12 col-md-6 col-lg-4">
        <article class="card h-100">
          <div class="card-body text-center">

            <!-- Category -->
            <?php if (!empty($fs['Category'])): ?>
              <h3 class="h6 mb-2"><?= esc($fs['Category']) ?></h3>
            <?php endif; ?>

            <!-- Position -->
            <?php if (!empty($fs['Position'])): ?>
              <p class="mb-1"><strong><?= esc($fs['Position']) ?></strong></p>
            <?php endif; ?>

            <!-- Name -->
            <p class="mb-2"><?= esc($fs['Name']) ?></p>

            <!-- Email -->
            <?php if (!empty($fs['Email'])): ?>
              <p class="mb-1">
                <a href="mailto:<?= esc($fs['Email']) ?>" class="link-success text-decoration-none">
                  <?= esc($fs['Email']) ?>
                </a>
              </p>
            <?php endif; ?>

            <!-- Website URL -->
            <?php if (!empty($fs['Url'])): ?>
              <p class="mb-1">
                <a href="<?= esc($fs['Url']) ?>" target="_blank" class="link-success text-decoration-none">
                  <?= esc($fs['Category']) ?>
                </a>
              </p>
            <?php endif; ?>

            <!-- Phone -->
            <?php if (!empty($fs['Phone'])): ?>
              <p class="mb-1">
                <?php if (!empty($fs['PhoneLocation'])): ?>
                  <?= esc($fs['PhoneLocation']) ?>:
                <?php endif; ?>
                <a href="tel:<?= esc($fs['Phone']) ?>" class="link-success text-decoration-none">
                  <?= esc($fs['Phone']) ?>
                </a>
              </p>
            <?php endif; ?>

            <!-- Notes -->
            <?php if (!empty($fs['Notes'])): ?>
              <p class="mt-2 small text-muted">
                <?= nl2br(esc($fs['Notes'])) ?>
              </p>
            <?php endif; ?>

          </div>
        </article>
      </div>
    <?php endforeach; ?>
  </div>
<?php endif; ?>
