<?php
// /WebSite/townstaffpositions/show.php
require_once __DIR__ . '/../../config/config.php';
require_once __DIR__ . '/../app/Models/DB.php';
require_once __DIR__ . '/../app/Helpers/Helpers.php';

use App\Models\DB;
use App\Helpers\HELP;

//$id = isset($_GET['id']) ? (int)$_GET['id'] : 0;
$id = isset($_GET['townstaffid']) ? (int)$_GET['townstaffid'] : 0;


$pdo = DB::pdo();

$stmt = $pdo->prepare("SELECT * FROM townstaffpositions WHERE Id = ?");
$stmt->execute([$id]);
$row = $stmt->fetch(PDO::FETCH_ASSOC);

//function esc($v) { return htmlspecialchars($v ?? '', ENT_QUOTES, 'UTF-8'); }

// url() helper (copied from index.php)
//function url($path = '') {
//    global $BASE_URL;
//    $path = ltrim($path, '/');
//    return ($BASE_URL ? $BASE_URL . '/' : '/') . $path;
//}

if (!$row) {
//    http_response_code(404);
    echo "<div class='container py-5'><p class='text-danger'>Town staff information not found.</p></div>";
    exit;
}
?>

<div class="container py-4">

  <div class="row justify-content-center">
    <div class="col-12 col-lg-8">

      <article class="card shadow-sm">
        <div class="card-body">

          <!--a href="<?= HELP::url('/') ?>"
             class="btn btn-outline-secondary btn-sm">
             ← Back
          </a-->

          <button type="button"
                  class="btn btn-outline-secondary btn-sm mb-2"
                  onclick="window.history.length > 1 ? history.back() : window.location='/'">
              &larr; Back
          </button>

          <h1 class="h4 text-center mb-4">Town Staff - <?= esc($row['JobTitle']) ?></h1>

          <?php if (!empty($row['PersonName'])): ?>
            <p><strong>Name:</strong> <?= nl2br(esc($row['PersonName'])) ?></p>
          <?php endif; ?>

          <?php if (!empty($row['Address1'])): ?>
            <p><strong>Address 1:</strong> <?= nl2br(esc($row['Address1'])) ?></p>
          <?php endif; ?>

          <?php if (!empty($row['Address2'])): ?>
            <p><strong>Address 2:</strong> <?= nl2br(esc($row['Address2'])) ?></p>
          <?php endif; ?>

          <?php if (!empty($row['Town']) || !empty($row['State']) || !empty($row['Zip'])): ?>
            <p><strong>Town, State, Zip:</strong>
              <?= esc($row['Town']) ?>,
              <?= esc($row['State']) ?>
              <?= esc($row['Zip']) ?>
            </p>
          <?php endif; ?>

          <?php if (!empty($row['Phone1'])): ?>
            <p><strong>Phone 1:</strong> <?= esc($row['Phone1']) ?></p>
          <?php endif; ?>

          <?php if (!empty($row['Phone2'])): ?>
            <p><strong>Phone 2:</strong> <?= esc($row['Phone2']) ?></p>
          <?php endif; ?>

          <?php if (!empty($row['Email'])): ?>
            <p><strong>Email:</strong>
              <a class="email-link" href="mailto:<?= esc($row['Email']) ?>">
                <?= esc($row['Email']) ?>
              </a>
            </p>
          <?php endif; ?>

          <?php if (!empty($row['Remarks'])): ?>
            <p><strong>Remarks:</strong><br><?= nl2br(esc($row['Remarks'])) ?></p>
          <?php endif; ?>

        </div>
      </article>

    </div>
  </div>

</div>
